#version 450 compatibility


layout (location = 0) out vec3 shadowcolor0Out;
layout (location = 1) out vec4 shadowcolor1Out;

#include "/lib/Head/Common.inc"

in vec2 texcoord;
in vec3 tint;
in vec3 normal;
in vec3 minecraftPos;
in float isWater;

in vec4 lmcoord;

uniform sampler2D tex;
/*
#include "/lib/Water/WaterWave.glsl"

vec4 CalculateWaterCaustics(in vec3 worldPos)
{
	vec2 dither = rand(texcoord + sin(frameTimeCounter)).xy / 2.0;

	vec3 lookupCenter = worldPos.xyz + vec3(0.0, 1.0, 0.0);

	float caustics = 0.0;

	vec3 wavesNormal = vec3(-1.0);

	for (float i = -1.0; i <= 1.0; i++) {
		for (float j = -1.0; j <= 1.0; j++) {
			vec2 offset = (dither + vec2(i, j)) * 0.1;
			vec3 lookupPoint = lookupCenter;
            lookupPoint.xz += offset;

			wavesNormal = GetWavesNormal(lookupPoint).xzy;

			vec3 refractVector = refract(vec3(0.0, 1.0, 0.0), wavesNormal.xyz, 1.0 / WATER_REFRACT_IOR);
			vec3 collisionPoint = lookupPoint - refractVector / refractVector.y;
            collisionPoint -= worldPos.xyz;

			//float dist = distance(collisionPoint, worldPos.xyz);
			float dist = dot(collisionPoint, collisionPoint);

			caustics += 1.0 - saturate(dist * 1e2);

		}
	}

	caustics = caustics * 0.4 + 0.2;

	return vec4(wavesNormal, caustics);
}
*/
void main() {
	if (isWater > 0.5) {
		shadowcolor0Out = vec3(1.0);
		shadowcolor1Out.w = minecraftPos.y * rcp(512.0) + 0.25;
	}else{
		vec4 albedo = texture(tex, texcoord);
		if (albedo.a < 0.1) discard;
		shadowcolor0Out = mix(vec3(1.0), albedo.rgb * tint, pow(albedo.a, 0.4));
	}

	shadowcolor1Out.xy = EncodeNormal(normal);
	shadowcolor1Out.z = lmcoord.y * 0.5 + 0.5;
}
